﻿using System;
using System.Reflection;

/// <summary>
///     Wykonywanie refleksji
/// </summary>
class Reflecting
{
    static void Main(string[] args)
    {
        Reflecting reflect = new Reflecting();

        Assembly myAssembly
            = Assembly.LoadFrom("Rozdzial 16.exe");

        reflect.GetReflectionInfo(myAssembly);

        Console.ReadKey();
    }

    void GetReflectionInfo(Assembly myAssembly)
    {
        Type[] typeArr = myAssembly.GetTypes();

        foreach (Type type in typeArr)
        {
            Console.WriteLine("\nTyp: {0}\n", type.FullName);

            ConstructorInfo[] MyConstructors
                = type.GetConstructors();
            foreach (ConstructorInfo constructor
                     in MyConstructors)
            {
                Console.WriteLine("\tKonstruktor: {0}",
                                  constructor.ToString());
            }
            Console.WriteLine();

            FieldInfo[] MyFields = type.GetFields();
            foreach (FieldInfo field in MyFields)
            {
                Console.WriteLine("\tPole: {0}",
                                  field.ToString());
            }
            Console.WriteLine();

            MethodInfo[] MyMethods = type.GetMethods();
            foreach (MethodInfo method in MyMethods)
            {
                Console.WriteLine("\tMetoda: {0}",
                                  method.ToString());
            }
            Console.WriteLine();

            PropertyInfo[] MyProperties
                = type.GetProperties();

            foreach (PropertyInfo property in MyProperties)
            {
                Console.WriteLine("\tWłaściwość: {0}",
                                  property.ToString());
            }
            Console.WriteLine();

            EventInfo[] MyEvents = type.GetEvents();
            foreach (EventInfo anEvent in MyEvents)
            {
                Console.WriteLine("\tZdarzenie: {0}",
                                  anEvent.ToString());
            }
            Console.WriteLine();
        }
    }
}
